#! /bin/tcsh -f
#
#
#
set chis = ( $* )

set CELL = `awk '/^CRYST/{print $2,$3,$4,$5,$6,$7}' ../cell.pdb`
set logfile = /dev/null
set GRID = ( 128 128 128 )

setenv CCP4_SCR /dev/shm/${USER}/refmac_$$_/
mkdir -p $CCP4_SCR

echo "BUILD LYS A4 $chis\nBUILD HIS A6 t 60 " |\
  cat - ../refminout.pdb |\
  build_side.awk >! minme.pdb

minimize.com minme.pdb | tee minimize1.log

refmac5 xyzin refminout.pdb xyzout Hadded.pdb << EOF | tee hadd.log
refi type ideal
make hydr A
make hout Y
EOF

cat Hadded.pdb |\
awk '/^CRYST/{print} ! /^ATOM|^HETAT/{next}\
  {print substr($0,1,55) " 1.00" substr($0,61)}' |\
cat >! fullocc.pdb

refmac5 xyzin fullocc.pdb xyzout minimized.pdb << EOF | tee hmin.log
refi type ideal
ncyc 500
bfactor set 15
make hydr Y
make hout Y
EOF





