#! /bin/tcsh -f
#
#
#
set B_of_CA = "$1"
set B_of_NZ = "$2"
set shift   = "$3"
set shiftseed = "$4"

set B_of_NE

if( "$B_of_CA" == "" ) set B_of_CA = 15
# based on random sampling of 
if( "$B_of_NZ" == "" ) set B_of_NZ = `echo $B_of_CA | awk '{print 3.34*$1**0.75}'`
if( "$B_of_NE" == "" ) set B_of_NE = `echo $B_of_CA | awk '{print $1+3.4}'`
if( "$shift" == "" ) set shift = 0
if( "$shiftseed" == "" ) set shiftseed = 1

set ksol = 0.33
set Bsol = `echo $B_of_NZ 10 | awk '{print $1+$2}'`
set reso = 1

set t = tempfile

set logfile = /dev/null
set GRID = ( 128 128 128 )

setenv CCP4_SCR /dev/shm/jamesh/refmac_$$_/
mkdir -p $CCP4_SCR


set gdevs = `echo "\n\n" | ~/awk/gaussrand.awk -v seed=$shiftseed`
set xyzshift = `echo $gdevs $shift | awk '{print $1*$NF,$2*$NF,$3*$NF}'`

echo "shifting by $xyzshift    $shiftseed"
pdbset xyzin minimized.pdb xyzout shifted.pdb << EOF  >> $logfile
shift $xyzshift
EOF


set CELL = `awk '/^CRYST/{print $2,$3,$4,$5,$6,$7}' ../cell.pdb`
egrep "^CRYST" ../cell.pdb >! mapme.pdb

echo $B_of_CA $B_of_NZ $B_of_NE |\
cat -  shifted.pdb |\
awk 'NR==1{Bmain=$1;lysBstep=($2-$1)/4;hisBstep=($3-$1)/3\
       s["G"]=1;s["D"]=2;s["E"]=3;s["Z"]=4}\
  ! /^ATOM|^HETAT/{next}\
  {greek=substr($0,15,1);B=Bmain;pre=substr($0,1,60);post=substr($0,67)}\
  /LYS/{B+=lysBstep*s[greek]}\
  /HIS/{B+=hisBstep*s[greek]}\
  {printf("%s%6.2f%s\n",pre,B,post)}' |\
cat >> mapme.pdb



set pdbfile = mapme.pdb


sfall xyzin $pdbfile mapout protein.map << EOF  >> $logfile
mode atmmap
CELL $CELL
SYMM 1
resolution $reso
GRID 128 128 128
FORM NGAUSS 5
EOF

# with bulk solvent
echo "with solvent"
rm -f fmodel.mtz
phenix.fmodel $pdbfile k_sol=$ksol b_sol=$Bsol high_res=$reso \
  algorithm=direct file_name=fmodel.mtz > $logfile



# now with bulk solvent turned off
echo "no solvent"
rm -f nobulk.mtz
phenix.fmodel $pdbfile k_sol=0 b_sol=$Bsol high_res=$reso \
  algorithm=direct file_name=nobulk.mtz > $logfile


# make the maps
fft hklin fmodel.mtz mapout ${t}ffted.map << EOF > $logfile
labin F1=FMODEL PHI=PHIFMODEL
GRID $GRID
EOF
echo "axis Z X Y" |\
 mapmask mapin ${t}ffted.map mapout fmodel.map > $logfile
rm -f ${t}ffted.map


fft hklin nobulk.mtz mapout ${t}ffted.map << EOF > $logfile
labin F1=FMODEL PHI=PHIFMODEL
GRID $GRID
EOF
echo "axis Z X Y" |\
 mapmask mapin ${t}ffted.map mapout ${t}nobulk.map > $logfile
rm -f ${t}ffted.map




# subtract to isolate solvent region
echo "subtracting nobulk map from sharp-solvent map"
echo scale factor -1 | mapmask mapin ${t}nobulk.map mapout ${t}neg.map > $logfile
echo "maps add" | mapmask mapin1 fmodel.map mapin2 ${t}neg.map mapout solvent.map > $logfile


sfall mapin solvent.map hklout solvent.mtz << EOF >> $logfile
mode sfcalc mapin
resolution 1
EOF

cad hklin1 fmodel.mtz hklin2 solvent.mtz hklout freeme.mtz << EOF >> $logfile
labin file 1 E1=FMODEL E2=PHIFMODEL
labout file 1 E1=F E2=PHIB
labin file 2 E1=FC E2=PHIC
labout file 2 E1=Fpart E2=PHIpart
EOF

echo "FreeR"
FreeRer.com freeme.mtz  >> $logfile
mv FreeRed.mtz refme.mtz

rm -f ${t}* 
rm -f freeme.mtz solvent.mtz freeR_flag.mtz XPLOR.cv


