#! /bin/tcsh -f
#
#   create a bouquet of side chains, try different models to see which is least bad
#

set CELL = ( 12 18 14 90 90 90 )
set alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXY"

set Bfac = 20
set shift = 0.2
set seed = 0

set signoise = 100
set sigadd   = 0.01

set reso = 2.0

set path = ( `dirname $0` $path )

set phenixopts = ( prefix=phenix \
  strategy=individual_sites+individual_adp occupancies.remove_selection=All \
  nqh_flips=False hydrogens.refine=individual )

# set to empty if you don't have slurm
set srun = "srun"

set logfile = debug.log
touch $logfile



if(-e rightanswer.pdb && -e rightanswer.mtz) goto gotright


echo "making ground truth..."
echo "" >! empty.pdb
echo "CELL $CELL\nSPACE 1" | pdbset xyzin empty.pdb xyzout cell.pdb >> $logfile 
rm empty.pdb




if(! -e supertwist.awk) then
  echo "getting helix generator progarm"
  wget https://bl831.als.lbl.gov/~jamesh/supertwist/supertwist.awk
  chmod a+x ./supertwist.awk
endif

# need some balast coordinates to fix the scale
echo "" | ./supertwist.awk >! supertwist.pdb
grep " A " supertwist.pdb | awk '$6>=1 && $6<=7{print}\
   $6==8 && / N /{gsub("N","O");\
    print substr($0,1,12) " OXT ALA A   7" substr($0,27)}' |\
cat >! heptad.pdb
grep "CA  ALA A   4 " heptad.pdb
pdbset xyzin heptad.pdb xyzout minme.pdb << EOF >> $logfile
cell $CELL
space 1
renumber 1
bfactor $Bfac
shift -6.214 -0.542 -6.249
EOF
awk '/^ATOM/{print substr($0,31)}' minme.pdb  | avg.awk 
minimize.com minme.pdb | tee minimize1.log

cat << EOF >! rotamers.txt
m t t t 
t t t t 
m m t t 
m t t m 
t p t t 
t t t m 
p t t t 
p t t t 
p t t p 
t t m m 
EOF

set n = 0
foreach n ( `awk '{print NR}' rotamers.txt` )
set chis = `head -n $n rotamers.txt | tail -n 1`
mkdir -p rotamer${n}
cd rotamer${n}/
$srun ../rotamer_rigamrol.com $chis | tee rigamrol.log &
sleep 0.1
cd ..
end

set rotamers = `seq 1 10`



foreach r ( $rotamers )
   cd rotamer${r}/

   $srun ../map_rigamrol.com $Bfac "" $shift $r | tee map_rigamrol.log &

   cd ..
end
wait

egrep "^CRYST" cell.pdb >! rightanswer.pdb
set i = 0
foreach r ( $rotamers )
   @ i = ( $i + 1 )
   set conf = `echo $i $alphabet | awk '{print substr($NF,$1,1)}'`
   egrep "^ATOM" rotamer${r}/mapme.pdb |\
   reformatpdb.awk -v CONF=$conf -v CHAIN=$conf -v OCC=$scale |\
   cat >> rightanswer.pdb
end



rm -f sfallme.map solvent.map
foreach r ( $rotamers )
   if(! -e sfallme.map) then
     cp rotamer${r}/fmodel.map sfallme.map
     cp rotamer${r}/solvent.map solvent.map
     continue
   endif
   echo maps add |\
   mapmask mapin1 sfallme.map mapin2 rotamer${r}/fmodel.map mapout new.map
   mv new.map sfallme.map
   echo maps add |\
   mapmask mapin1 solvent.map mapin2 rotamer${r}/solvent.map mapout new.map
   mv new.map solvent.map
end
set scale = `echo $#goodrs | awk '{print 1/$1}'`
echo scale factor $scale |\
mapmask mapin sfallme.map mapout new.map 
mv new.map sfallme.map
echo scale factor $scale |\
mapmask mapin solvent.map mapout new.map 
mv new.map solvent.map

cp sfallme.map rightanswer.map

echo "sfall"
sfall mapin sfallme.map hklout sfalled.mtz << EOF >> $logfile
mode sfcalc mapin
resolution 1
EOF

sfall mapin solvent.map hklout solvent.mtz << EOF >> $logfile
mode sfcalc mapin
resolution 1
EOF

cad hklin1 sfalled.mtz hklin2 solvent.mtz hklout rightanswer.mtz << EOF >> $logfile
labin file 1 E1=FC E2=PHIC
labout file 1 E1=F E2=PHIB
labin file 2 E1=FC E2=PHIC
labout file 2 E1=Fpart E2=PHIpart
EOF







gotright:

cad hklin1 rightanswer.mtz hklout sigme.mtz << EOF >> $logfile
labin file 1 all
resolution over_all $reso
EOF


set minF = `echo $sigadd | awk '{print $1/3}'`
rm -f freeme.mtz
sftools << EOF >> $logfile
read sigme.mtz
calc seed $seed
calc W COL FOM = 0.95 
calc col re = COL F $signoise /
calc col resq = COL re 2 **
calc col besq = $sigadd 2 **
calc col tesq = COL resq COL besq +
calc Q COL SIGF = COL tesq 0.5 **
calc col noise = COL SIGF RAN_G *
calc F col Fnz = COL F col noise +
select col Fnz < $minF
calc F col Fnz = $minF
select all
calc col F = col Fnz 
write freeme.mtz col F SIGF PHIB FOM Fpart PHIpart
stop
EOF

diff.com sigme.mtz freeme.mtz | tee diff.log

echo "FreeR"
FreeRer.com freeme.mtz  >> $logfile
cp FreeRed.mtz refme.mtz


mv refme.mtz refme1.mtz
cad hklin1 FreeRed.mtz hklout refme_part.mtz << EOF
labin file 1 all
resolution over_all $reso
EOF
cad hklin1 refme_part.mtz hklout refme.mtz << EOF
labin file 1 E1=F E2=SIGF E3=FreeR_flag
EOF















mkdir rightanswer
cd rightanswer
rm *

ln -sf ../refme_part.mtz refme.mtz
cp ../rightanswer.pdb start.pdb

cat << EOF >! refmac_opts.txt
solvent no
scpart 1
damp 0.1 0.1 0.1
make hydr Y
make hout Y
EOF

$srun converge_refmac.com start.pdb refme.mtz nosalvage >! converge1.log &

cd ..



cd minusoneH/
rm *

ln -sf ../refme_part.mtz refme.mtz
egrep -v "HE2.HIS" ../rightanswer.pdb >! start.pdb

cat << EOF >! refmac_opts.txt
solvent no
scpart 1
damp 0.1 0.1 0.1
make hydr Y
make hout Y
EOF

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..







mkdir refmacdefaults
cd refmacdefaults
rm *

ln -sf ../refme.mtz .
cp ../rightanswer.pdb start.pdb

cat << EOF >! refmac_opts.txt
damp 0.1 0.1 0.1
EOF

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..











mkdir matchsolparm
cd matchsolparm
rm *

ln -sf ../refme.mtz .
cp ../rightanswer.pdb start.pdb

cat << EOF >! refmac_opts.txt
solvent vdwprobe 1.1 ionprobe 1.1 rshrink 0.9
damp 0.1 0.1 0.1
EOF

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..
























mkdir stump
cd stump
rm *

ln -sf ../refme.mtz .

cat << EOF >! refmac_opts.txt
labin FP=F SIGFP=SIGF FREE=FreeR_flag
make hydr Y
make hout Y
damp 0.1 0.1 0.1
EOF

awk '/^CRYST/ || substr($0,17,1)=="A"' ../rightanswer.pdb |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/{next}\
     /HE2.HIS/{next}\
   {print}' |\
reformatpdb.awk -v CONF=" " -v OCC=1 >! start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..










mkdir stumpCG
cd stumpCG
rm *

ln -sf ../refme.mtz .

cat << EOF >! refmac_opts.txt
labin FP=F SIGFP=SIGF FREE=FreeR_flag
damp 0.1 0.1 0.1
EOF

egrep "CG .LYS" ../rotamer54/minimized.pdb | reformatpdb.awk -v CONF=A -v OCC=0.33 >! CG.pdb
egrep "CG .LYS" ../rotamer81/minimized.pdb | reformatpdb.awk -v CONF=B -v OCC=0.33 >> CG.pdb
egrep "CG .LYS" ../rotamer27/minimized.pdb | reformatpdb.awk -v CONF=C -v OCC=0.33 >> CG.pdb

egrep "^CRYST" ../cell.pdb >! start.pdb
awk '/^ATOM/' ../rotamer54/minimized.pdb |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/{next}\
     /HE2.HIS/{next}\
   {print}' |\
cat - CG.pdb |\
sort -k2g >> start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..












mkdir stumpCG10
cd stumpCG10
rm *

ln -sf ../refme.mtz .

cat << EOF >! refmac_opts.txt
labin FP=F SIGFP=SIGF FREE=FreeR_flag
damp 0.1 0.1 0.1
EOF

egrep "CG .LYS" ../rightanswer.pdb | reformatpdb.awk -v CHAIN="A" >! CG.pdb

egrep "^CRYST" ../cell.pdb >! start.pdb
awk '/^ATOM/' ../rotamer54/minimized.pdb |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/{next}\
     /HE2.HIS/{next}\
   {print}' |\
cat - CG.pdb |\
sort -k2g >> start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..










mkdir stumpCGCD10
cd stumpCGCD10
rm *

ln -sf ../refme.mtz .

cat << EOF >! refmac_opts.txt
labin FP=F SIGFP=SIGF FREE=FreeR_flag
damp 0.1 0.1 0.1
EOF

egrep "C[GD] .LYS" ../rightanswer.pdb | reformatpdb.awk -v CHAIN="A" >! fray.pdb

egrep "^CRYST" ../cell.pdb >! start.pdb
awk '/^ATOM/' ../rotamer54/minimized.pdb |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/{next}\
     /HE2.HIS/{next}\
   {print}' |\
cat - fray.pdb |\
sort -k2g >> start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..















mkdir stumpGDE10
cd stumpGDE10
rm *

ln -sf ../refme.mtz .

cat << EOF >! refmac_opts.txt
damp 0.1 0.1 0.1
EOF

egrep "C[GDE] .LYS" ../rightanswer.pdb | reformatpdb.awk -v CHAIN="A" >! fray.pdb

egrep "^CRYST" ../cell.pdb >! start.pdb
awk '/^ATOM/' ../rotamer54/minimized.pdb |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/{next}\
     /HE2.HIS/{next}\
   {print}' |\
cat - fray.pdb |\
sort -k2g >> start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..









mkdir stumpGDEZ10
cd stumpGDEZ10
#rm *

ln -sf ../refme.mtz .

cat << EOF >! refmac_opts.txt
damp 0.1 0.1 0.1
EOF

egrep "[CN][GDEZ] .LYS" ../rightanswer.pdb | reformatpdb.awk -v CHAIN="A" >! fray.pdb

egrep "^CRYST" ../cell.pdb >! start.pdb
awk '/^ATOM/' ../rotamer54/minimized.pdb |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/{next}\
     /HE2.HIS/{next}\
   {print}' |\
cat - fray.pdb |\
sort -k2g >> start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..








foreach nconf ( `seq 1 10` )

set dir = nconf${nconf}
set scale = `echo $nconf | awk '{print 1/$1}'`

mkdir -p $dir

egrep "^CRYST" cell.pdb >! $dir/start.pdb
set i = 0
foreach r ( $rotamers )
   @ i = ( $i + 1 )
   if( $i > $nconf ) break
   set chain = `echo $i $alphabet | awk '{print substr($NF,$1,1)}'`
   set conf = $chain
   if($nconf == 1 ) set conf = " "
   egrep "^ATOM" rotamer${r}/minimized.pdb |\
   reformatpdb.awk -v CONF=$conf -v CHAIN=$chain -v OCC=$scale |\
   egrep -v "HE2.HIS" |\
   cat >> $dir/start.pdb
end

cd $dir
ln -sf ../refme.mtz .

cat << EOF >! refmac_opts.txt
damp 0.1 0.1 0.1
EOF

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..

end













# onestump
set scale = 1
foreach conf1 ( `seq 1 10` )

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = onestump${chain1}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/{next}\
   {print}' |\
  reformatpdb.awk -v OCC=$scale |\
  cat >> start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..

end











set scale = 1
foreach conf1 ( `seq 1 10` )

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = stumpaniso${chain1}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
refi bref aniso
damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/ && $NF!="H"{next}\
   {print}' |\
  reformatpdb.awk -v OCC=$scale |\
  cat >> start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..

end


















# twostump
set scale = 0.5

foreach conf1 ( `seq 1 10` )
foreach conf2 ( `seq 1 10` )

  if( $conf1 >= $conf2 ) continue

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain2 = `echo $conf2 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = twostump${chain1}${chain2}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 $chain2 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/{next}\
   {print}' |\
  reformatpdb.awk -v OCC=$scale |\
  cat >> start.pdb

$srun converge_refmac.com start.pdb refme.mtz nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..

end
end











# tenstump

  set dir = tenstump
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
damp 0.1 0.1 0.1
EOF

  cat ../rightanswer.pdb |\
awk '/LYS/ && substr($0,15,1)~/[GDEZ]/ || $NF=="H"{next}\
   {print}' |\
  cat >! start.pdb

$srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..





















set scale = 1

foreach conf ( `seq 1 10` )

  set chain = `echo $conf $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = oneconf${chain}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  set conf = $chain
  echo $conf |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{++sel[$1]} ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..
end

tail -n 1 oneconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
tee oneconf_sorted.txt

tail -n 10 oneconf*/phenix.log | awk '/^==/{f=$2} \
 /^Final/{print $0,f}' |\
 sort -k7gr |\
tee oneconf_phenix.txt









foreach conf ( `seq 1 10` )

  set chain = `echo $conf $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = zerocc${chain}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  set conf = $chain
  echo $conf |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{++sel[$1]} ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
awk '{occ=1;pre=substr($0,1,54);post=substr($0,61)}\
     /LYS/ && substr($0,15,1)~/[GDEZ]/{occ=0}\
     {printf("%s%6.2f%s\n",pre,occ,post)}' |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz keep_zeroocc >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..
end

tail -n 1 zerocc*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
tee zerocc_sorted.txt

tail -n 10 zerocc*/phenix.log | awk '/^==/{f=$2} \
 /^Final/{print $0,f}' |\
 sort -k7gr |\
tee zerocc_phenix.txt













set scale = 0.5

foreach conf1 ( `seq 1 10` )
foreach conf2 ( `seq 1 10` )

  if( $conf1 >= $conf2 ) continue

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain2 = `echo $conf2 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = twoconf${chain1}${chain2}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 $chain2 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  egrep -v "HE2" |\
  cat >> start.pdb

  $srun  converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..

end
end

tail -n 1 twoconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
tee twoconf_sorted.txt







set scale = 0.33

foreach conf1 ( `seq 1 10` )
foreach conf2 ( `seq 1 10` )
foreach conf3 ( `seq 1 10` )

  if( $conf1 >= $conf2 ) continue
  if( $conf2 >= $conf3 ) continue

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain2 = `echo $conf2 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain3 = `echo $conf3 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = threeconf${chain1}${chain2}${chain3}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 $chain2 $chain3 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  egrep -v "HE2" |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..

end
end
end

tail -n 1 threeconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
 tee threeconf_sorted.txt









set scale = 0.25

foreach conf1 ( `seq 1 10` )
foreach conf2 ( `seq 1 10` )
foreach conf3 ( `seq 1 10` )
foreach conf4 ( `seq 1 10` )

  if( $conf1 >= $conf2 ) continue
  if( $conf2 >= $conf3 ) continue
  if( $conf3 >= $conf4 ) continue

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain2 = `echo $conf2 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain3 = `echo $conf3 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain4 = `echo $conf4 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = quadconf${chain1}${chain2}${chain3}${chain4}
  if(-e ${dir}/refmacout.pdb) continue
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 $chain2 $chain3 $chain4 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  egrep -v "HE2" |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..

end
end
end
end

tail -n 1 quadconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
 tee quadconf_sorted.txt













set scale = 0.2

foreach conf1 ( `seq 1 10` )
foreach conf2 ( `seq 1 10` )
foreach conf3 ( `seq 1 10` )
foreach conf4 ( `seq 1 10` )
foreach conf5 ( `seq 1 10` )

  if( $conf1 >= $conf2 ) continue
  if( $conf2 >= $conf3 ) continue
  if( $conf3 >= $conf4 ) continue
  if( $conf4 >= $conf5 ) continue

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain2 = `echo $conf2 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain3 = `echo $conf3 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain4 = `echo $conf4 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain5 = `echo $conf5 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = pentaconf${chain1}${chain2}${chain3}${chain4}${chain5}
  if(-e ${dir}/refmacout.pdb) continue
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 $chain2 $chain3 $chain4 $chain5 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  egrep -v "HE2" |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..

end
end
end
end
end

tail -n 1 pentaconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
 tee pentaconf_sorted.txt














set scale = 0.16

foreach conf1 ( `seq 1 10` )
foreach conf2 ( `seq 1 10` )
foreach conf3 ( `seq 1 10` )
foreach conf4 ( `seq 1 10` )
foreach conf5 ( `seq 1 10` )
foreach conf6 ( `seq 1 10` )

  if( $conf1 >= $conf2 ) continue
  if( $conf2 >= $conf3 ) continue
  if( $conf3 >= $conf4 ) continue
  if( $conf4 >= $conf5 ) continue
  if( $conf5 >= $conf6 ) continue

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain2 = `echo $conf2 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain3 = `echo $conf3 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain4 = `echo $conf4 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain5 = `echo $conf5 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain6 = `echo $conf6 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = hexaconf${chain1}${chain2}${chain3}${chain4}${chain5}${chain6}
  if(-e ${dir}/refmacout.pdb) continue
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 $chain2 $chain3 $chain4 $chain5 $chain6 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  egrep -v "HE2" |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..

end
end
end
end
end
end

tail -n 1 hexaconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
 tee hexaconf_sorted.txt





set stuff = 1000
while ( $stuff > 100 )
  set stuff = `squeue | wc -l`
  sleep 30
end




set scale = 0.14

foreach conf1 ( `seq 1 10` )
foreach conf2 ( `seq 1 10` )
foreach conf3 ( `seq 1 10` )
foreach conf4 ( `seq 1 10` )
foreach conf5 ( `seq 1 10` )
foreach conf6 ( `seq 1 10` )
foreach conf7 ( `seq 1 10` )

  if( $conf1 >= $conf2 ) continue
  if( $conf2 >= $conf3 ) continue
  if( $conf3 >= $conf4 ) continue
  if( $conf4 >= $conf5 ) continue
  if( $conf5 >= $conf6 ) continue
  if( $conf6 >= $conf7 ) continue

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain2 = `echo $conf2 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain3 = `echo $conf3 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain4 = `echo $conf4 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain5 = `echo $conf5 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain6 = `echo $conf6 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain7 = `echo $conf7 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = heptaconf${chain1}${chain2}${chain3}${chain4}${chain5}${chain6}${chain7}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 $chain2 $chain3 $chain4 $chain5 $chain6 $chain7 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  egrep -v "HE2" |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..

end
end
end
end
end
end
end
wait

tail -n 1 heptaconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
 tee heptaconf_sorted.txt








set scale = 0.12

foreach conf1 ( `seq 1 10` )
foreach conf2 ( `seq 1 10` )
foreach conf3 ( `seq 1 10` )
foreach conf4 ( `seq 1 10` )
foreach conf5 ( `seq 1 10` )
foreach conf6 ( `seq 1 10` )
foreach conf7 ( `seq 1 10` )
foreach conf8 ( `seq 1 10` )

  if( $conf1 >= $conf2 ) continue
  if( $conf2 >= $conf3 ) continue
  if( $conf3 >= $conf4 ) continue
  if( $conf4 >= $conf5 ) continue
  if( $conf5 >= $conf6 ) continue
  if( $conf6 >= $conf7 ) continue
  if( $conf7 >= $conf8 ) continue

  set chain1 = `echo $conf1 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain2 = `echo $conf2 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain3 = `echo $conf3 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain4 = `echo $conf4 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain5 = `echo $conf5 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain6 = `echo $conf6 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain7 = `echo $conf7 $alphabet | awk '{print substr($NF,$1,1)}'`
  set chain8 = `echo $conf8 $alphabet | awk '{print substr($NF,$1,1)}'`

  set dir = octaconf${chain1}${chain2}${chain3}${chain4}${chain5}${chain6}${chain7}${chain8}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chain1 $chain2 $chain3 $chain4 $chain5 $chain6 $chain7 $chain8 |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  egrep -v "HE2" |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..

end
end
end
end
end
end
end
end

tail -n 1 octaconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
 tee octaconf_sorted.txt


wait






set scale = 0.11

foreach nonconf1 ( `seq 1 10` )

  set chains = `echo $nonconf1 $alphabet | awk '{for(i=1;i<=10;++i)if(i!=$1)print substr($NF,i,1)}'`
  set chainchain = `echo $chains | awk '{gsub(" ","");print}'`

  set dir = nonaconf${chainchain}
  mkdir -p $dir
  cd $dir
  ln -sf ../refme.mtz .

  cat << EOF >! refmac_opts.txt
#damp 0.1 0.1 0.1
EOF

  egrep "^CRYST" ../cell.pdb >! start.pdb
  echo $chains |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{for(i=1;i<=NF;++i)++sel[$i]}\
    ! /^ATOM/{next} {c=substr($0,17,1)}\
      sel[c]{print}'  |\
  reformatpdb.awk -v OCC=$scale |\
  egrep -v "HE2" |\
  cat >> start.pdb

  $srun converge_refmac.com start.pdb refme.mtz >&! converge1.log &
  $srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

  cd ..

end

tail -n 1 nonaconf*/refmac_Rplot.txt | awk '/^==/{f=$2;getline;print $0,f}' |\
 sort -k3gr |\
 tee nonaconf_sorted.txt












mkdir stretch

echo reindex 10h,k,l | reindex hklin ../refme.mtz hklout reindexed.mtz | tee reindex.log
echo "labin file 1 all\nscale file 1 10" | cad hklin1 reindexed.mtz hklout refme.mtz

awk '/Cell Dim/{getline;getline;print "CELL",$0}' reindex.log |\
tail -n 1 |\
pdbset xyzin ../cell.pdb xyzout cell.pdb

egrep "^CRYS" cell.pdb >! start.pdb

foreach conf ( `seq 1 10` )

  set chain = `echo $conf $alphabet | awk '{print substr($NF,$1,1)}'`

  echo $conf $chain |\
  cat - ../rightanswer.pdb |\
  awk 'NR==1{m=$1;++sel[$2]} ! /^ATOM/{next}\
    {c=substr($0,17,1);typ=substr($0,18,4);resnum=substr($0,23,6)+0;\
     pre=substr($0,1,16);post=substr($0,61);\
     X=substr($0,31,8);YZ=substr($0,39,16)}\
     ! sel[c]{next}\
   {printf("%s %sA%4d    %8.3f%s%6.2f%s\n",pre,typ,resnum+12*(m-1),X+12*(m-5),YZ,1,post)}\
   /OXT/{print "TER"}' >> start.pdb
end

cat << EOF >! refmac_opts.txt
solvent vdwprobe 1.1 ionprobe 1.1 rshrink 0.9
damp 0.1 0.1 0.1
EOF

$srun converge_refmac.com start.pdb refme.mtz trials=20 nosalvage >&! converge1.log &
$srun phenix.refine start.pdb refme.mtz $phenixopts >&! phenix.log &

cd ..








foreach dir ( `ls -1td */ | egrep -v "^test|^cell|^nosig|^rotam|^resocut"` )
  if(-e ${dir}/CCright_stats.txt) continue
  cd $dir
  set refmac_CCright
  set phenix_CCright
  set rph
  set pph
  if(-e refmacout.mtz) then
    echo "labin F1=DELFWT PHI=PHDELWT" |\
        fft hklin refmacout.mtz mapout refmac_fofc.map >> $logfile
    echo "labin F1=FWT PHI=PHWT\nGRID $GRID" |\
        fft hklin refmacout.mtz mapout refmac_2fofc.map >> $logfile
    set refmac_CCright = `correlate.com ../rightanswer.map refmac_2fofc.map | awk '{print $NF}'`
    set stats = `echo | mapdump mapin refmac_fofc.map | awk '/density/{print $NF}'`
    set stats2 = `echo | mapdump mapin refmac_2fofc.map | awk '/density/{print $NF}'`
    set rph = `echo $stats $stats2 | awk 'NF==8{print $2/$NF,$2/$4}'`
    set rrf = `tail -n 1 refmac_Rplot.txt | awk '{print $2,$3}'`
  endif
  if( -e phenix_001.mtz) then
    echo "labin F1=FOFCWT PHI=PHFOFCWT" |\
        fft hklin phenix_001.mtz mapout phenix_fofc.map >> $logfile
    echo "labin F1=2FOFCWT PHI=PH2FOFCWT\nGRID $GRID" |\
        fft hklin phenix_001.mtz mapout phenix_2fofc.map >> $logfile
    set phenix_CCright = `correlate.com ../rightanswer.map phenix_2fofc.map | awk '{print $NF}'`
    set stats = `echo | mapdump mapin phenix_fofc.map | awk '/density/{print $NF}'`
    set stats2 = `echo | mapdump mapin phenix_2fofc.map | awk '/density/{print $NF}'`
    set pph = `echo $stats $stats2 | awk 'NF==8{print $2/$NF,$2/$4}'`
    set prf = `tail -n 10 phenix.log | awk '/^Final/{print $4*100,$NF*100}'`
  endif
  if( "$refmac_CCright" == "" ) set refmac_CCright = "n/d"
  if( "$phenix_CCright" == "" ) set phenix_CCright = "n/d"
  if( $#rph != 2 ) set rph = "n/d n/d "
  if( $#pph != 2 ) set pph = "n/d n/d "
  echo "$refmac_CCright  $phenix_CCright     $rph $pph    $rrf   $prf   $dir" |\
    tee CCright_stats.txt |\
    tee -a ../CCright_vs_trial.txt
  cd ..
end


rm -f best_worst.txt best_worst_fulldirs.txt
foreach trial ( stumpGDEZ10 refmacdefaults nonaconf octaconf heptaconf hexaconf pentaconf quadconf threeconf twoconf oneconf onestump twostump tenstump stumpaniso )

grep $trial CCright_vs_trial.txt |\
 sort -g |\
 awk '{printf("%s %8.2f %7.2f %8.1f         %s\n",$1,$7,$8,$4,$NF)}' |\
 awk 'NR==1{print $0,"0 worst"} END{print $0,"2 best"}' |\
tee -a best_worst_fulldirs.txt |\
 awk '{gsub("one","1 ");gsub("two","2 ");gsub("three","3 ");gsub("quad","4 ");gsub("penta","5 ");\
       gsub("hexa","6 ");gsub("hepta","7 ");gsub("octa","8 ");gsub("nona","9 ");\
       gsub("refmac|stump","10 ");;print}' |\
 tee -a best_worst.txt

end

awk '/best/{print $5"/refmacout.???"}' best_worst_fulldirs.txt









tar czvf ~/html/trimnotrim/testdata.tgz generate_test_data.com rightanswer.*



