#! /bin/tcsh -f
#
#
#

set CELL = ( $* )
set logfile = /dev/null
set GRID = ( 128 128 128 )

setenv CCP4_SCR /dev/shm/jamesh/refmac_$$_/
mkdir -p $CCP4_SCR

echo "CELL $CELL" |\
  pdbset xyzin ../rightanswer.pdb xyzout minme.pdb


refmac5 xyzin minme.pdb xyzout minimized.pdb << EOF | tee minimize.log
refi type ideal
ncyc 100
make hydr Y
make hout Y
EOF

molprobify_runme.com minimized.pdb tempfile=tempfile debug=1



distang xyzin minimized.pdb << EOF >! ${tempfile}distang.log
SYMM 1
DIST VDW
RADII C 3
RADII N 3
RADII O 3
RADII S 3
DMIN -1
FROM ATOM 1 to 99999
TO   ATOM 1 to 99999
END
EOF

# get residue types for each res number
cat minimized.pdb |\
awk '{print substr($0,22,1),substr($0,23,4),substr($0,18,3),"RESTYP"}' |\
 sort -u >! ${tempfile}restyps.txt

# get real VDW radii
cat ${CLIBD}/sc_radii.lib minimized.pdb |\
awk 'NF==3{gsub("*",".");++radii;typp[radii]="^"$1;atomp[radii]="^"$2;radius[radii]=$3;next}\
 ! /^ATOM|^HETAT/{next}\
    {typ=substr($0,18,3);atom=substr($0,12,5);gsub(" ","",atom);\
     r="";\
     for(i=radii;i>=1;--i)if(typ~typp[i] && atom~atomp[i]){r=radius[i];\
     print "MATCH:",i,typ,"~",typp[i],atom,"~",atomp[i],radius[i];break};\
    print "RADIUS",atom,typ,r}' |\
sort -u |\
egrep "^RADIUS" >! ${tempfile}radii.txt

cat << EOF >! ${tempfile}hbondstuff.txt
donor ARG NE
donor ARG NH1
donor ARG NH2
donor ASN ND2
donor HIS NE2
donor HIS ND1
donor SER OG
donor TYR OH
donor CYS SG
donor THR OG1
donor GLN NE2
donor LYS NZ
donor TRP NE1
donor N
acceptor O
acceptor ASN OD1
acceptor ASP OD1
acceptor ASP OD2
acceptor GLN OE1
acceptor GLU OE1
acceptor GLU OE2
acceptor SER OG
acceptor THR OG1
acceptor CYS SG
acceptor HIS ND1
acceptor TYR OH
acceptor MET SD
EOF


cat ${tempfile}distang.log |\
awk '/Atom I  Atom J   Dij/,/Symmetry matrix/' |\
cat ${tempfile}restyps.txt - |\
awk '$NF=="RESTYP"{restyp[$1,$2]=$3;next}\
     /^BOND|^STIFF|^PLANE/{++exclude[$2,$3];++exclude[$3,$2];next}\
     /^ANGLE/{++exclude[$2,$4];++exclude[$4,$2];next}\
    $1~/^[A-Za-z]$/ && $4~/^[A-Za-z]$/ && $4==$8{\
    f1c=$4;f2c=$8;dist=$9;symop=$10;atom1=$3;atom2=$7;\
    resnum1=$2;resnum2=$6;\
    split($0,w,"[][]");dxyz=w[2];\
    gsub("+"," +",dxyz);gsub("-"," -",dxyz);\
    if(dxyz=="")dxyz="0 0 0";\
    a1=atom1"_"resnum1;a2=atom2"_"resnum2;\
    if( exclude[a1,a2] ) next;\
    print f1c,f2c,dist,atom1,restyp[f1c,resnum1],resnum1,atom2,restyp[f2c,resnum2],resnum2,symop,dxyz}' |\
sort -k3g >! bump_vs_pair.txt



molprobify_runme.com minimized.pdb tempfile=tempfile debug=1


exit

set pdbfile = minimized.pdb
set ksol = 0.33
set Bsol = 20
set reso = 1

# with bulk solvent
echo "with solvent"
rm -f ss.mtz
phenix.fmodel $pdbfile k_sol=$ksol b_sol=$Bsol high_res=$reso \
  algorithm=direct file_name=fmodel.mtz > $logfile



# now with bulk solvent turned off
echo "no solvent"
rm -f nobulk.mtz
phenix.fmodel $pdbfile k_sol=0 b_sol=$Bsol high_res=$reso \
  algorithm=direct file_name=nobulk.mtz > $logfile















# make the maps
fft hklin fmodel.mtz mapout ${tempfile}ffted.map << EOF > $logfile
labin F1=FMODEL PHI=PHIFMODEL
GRID $GRID
EOF
echo "axis Z X Y" |\
 mapmask mapin ${tempfile}ffted.map mapout fmodel.map > $logfile
rm -f ${tempfile}ffted.map


fft hklin nobulk.mtz mapout ${tempfile}ffted.map << EOF > $logfile
labin F1=FMODEL PHI=PHIFMODEL
GRID $GRID
EOF
echo "axis Z X Y" |\
 mapmask mapin ${tempfile}ffted.map mapout nobulk.map > $logfile
rm -f ${tempfile}ffted.map




# subtract to isolate solvent region
echo "subtracting nobulk map from sharp-solvent map"
echo scale factor -1 | mapmask mapin nobulk.map mapout neg.map > $logfile
echo "maps add" | mapmask mapin1 fmodel.map mapin2 neg.map mapout solvent.map > $logfile



sfall xyzin minimized.pdb mapout protein.map << EOF  >> $logfile
mode atmmap
CELL $CELL
SYMM 1
resolution 1
GRID 128 128 128
FORM NGAUSS 5
EOF



sfall mapin solvent.map mapout sfalled.mtz << EOF  >> $logfile
mode sfcalc mapin
EOF




