/************************************************************************
                        Copyright 2001
                              by
                 The Board of Trustees of the 
               Leland Stanford Junior University
                      All rights reserved.

                       Disclaimer Notice

     The items furnished herewith were developed under the sponsorship
of the U.S. Government.  Neither the U.S., nor the U.S. D.O.E., nor the
Leland Stanford Junior University, nor their employees, makes any war-
ranty, express or implied, or assumes any liability or responsibility
for accuracy, completeness or usefulness of any information, apparatus,
product or process disclosed, or represents that its use will not in-
fringe privately-owned rights.  Mention of any product, its manufactur-
er, or suppliers shall not, nor is it intended to, imply approval, dis-
approval, or fitness for any particular use.  The U.S. and the Univer-
sity at all times retain the right to use and disseminate the furnished
items for any purpose whatsoever.                       Notice 91 02 01

   Work supported by the U.S. Department of Energy under contract
   DE-AC03-76SF00515; and the National Institutes of Health, National
   Center for Research Resources, grant 2P41RR01209. 

************************************************************************/

  /* image object v. 1.0 */

#ifndef LIBIMAGE_H
#define LIBIMAGE_H

#ifdef __cplusplus

extern "C" {

#endif

#define img_BAD_ARGUMENT    0x0001
#define img_BAD_ALLOC       0x0002
#define img_BAD_OPEN        0x0004
#define img_BAD_READ        0x0008
#define img_BAD_FORMAT      0x0010
#define img_BAD_FIELD       0x0020
#define img_BAD_WRITE       0x0040

  /* Tag */

typedef struct
{
  char                 *tag;
  char                 *data;
}
img_tag;


  /* Image */

typedef struct
{
  int                   tags;
  img_tag              *tag;

  int                   size [2];
  int                  *image;
}
img_object;


  /* Functions */

#define img_pixel(img,x,y) (((img)->image) [((img)->size) [1] * (int) (x) + (int) (y)])
#define img_columns(img)    ((img)->size [0])
#define img_rows(img)       ((img)->size [1])

img_object *img_open           ();
int         img_read           (img_object *img, const char *name);
int         img_close          (img_object *img);
int         img_delete_field   (img_object *img, const char *tag);
const char *img_get_field      (img_object *img, const char *tag);
int         img_set_field      (img_object *img, const char *tag, const char *data);
double      img_get_number     (img_object *img, const char *tag);
int         img_set_number     (img_object *img, const char *tag, const char *format,
                                                                  double data);
int         img_get_pixel      (img_object *img, int x, int y);
int         img_set_pixel      (img_object *img, int x, int y, int data);
int         img_set_dimensions (img_object *img, int columns, int rows);
int         img_get_dimension  (img_object *img, int dimension);

int         img_write_smv      (img_object *img, const char *name,
                                                 unsigned int bits);

#ifdef __cplusplus

}

#endif

#endif /* LIBIMAGE_H */

