# $Id: install.tcl 1.3 2003/05/17 10:56:30 s-imai s-imai $
#
# Copyright (C) 2000-2001 Satoshi Imai
#

wm title . {CWind1.4 Installer}

proc install {} {
	set ok 1
	set tpath [.f1.path.path get]
	if {![file isdirectory [file join $tpath lib]] || [glob [file join $tpath bin tclsh*.exe]]=="" } {
		tk_messageBox -title Error -icon error -message "invalid directory $tpath"
		set ok 0
	}
	if {$ok} {
		set fpath [file join $tpath lib/cwind1.4]
		if {[catch {file mkdir $fpath} err]} {
			tk_messageBox -title Error -icon error -message $err
			set ok 0
		}
	}
	if {$ok} {
		if {[catch {file copy -force cwind.dll $fpath} err]} {
			tk_messageBox -title Error -icon error -message $err
			set ok 0
		}
		if {[catch {file copy -force cwind.tcl $fpath} err]} {
			tk_messageBox -title Error -icon error -message $err
			set ok 0
		}
		if {[catch {file copy -force pkgIndex.tcl $fpath} err]} {
			tk_messageBox -title Error -icon error -message $err
			set ok 0
		}
		if {[catch {file copy -force Readme.txt $fpath} err]} {
			tk_messageBox -title Error -icon error -message $err
			set ok 0
		}
		catch {file delete -force $fpath/sample}
		if {[catch {file copy -force sample $fpath} err]} {
			tk_messageBox -title Error -icon error -message $err
			set ok 0
		}
	}
	if {$ok} {
		.f3.result configure -text {Installation completed.}
		.f2.inst configure -state disabled
		.f1.path.select configure -state disabled
		.f2.cancel configure -text Exit
	} else {
		.f3.result configure -text {Installation failed!}
	}
}

proc getdir {} {
	global tcl_version
	if {$tcl_version >= 8.3} {
		set dir [tk_chooseDirectory -initialdir [.f1.path.path get] -title "select a file in tcl direcory (e.g. readme.txt)" ]
		if {$dir != ""} {
			.f1.path.path delete 0 end
			.f1.path.path insert end $dir
		}
	} else {
		set dir [tk_getOpenFile -initialdir [.f1.path.path get] -title "select a file in tcl direcory (e.g. readme.txt)" ]
		if {$dir != ""} {
			.f1.path.path delete 0 end
			.f1.path.path insert end [file dirname $dir]
		}
	}
}

pack [frame .f0 -bd 5]
label .f0.label -text {Click "Install" to begin installation of CWind.}
pack .f0.label

pack [frame .f1 -bd 5]
label .f1.label -text {Please enter the installation folder:}
frame .f1.path
entry .f1.path.path -width 50
button .f1.path.select -text "..." -command getdir -highlightthickness 0
pack  .f1.label  .f1.path     -anchor w
pack .f1.path.path   -side left -fill x
pack .f1.path.select -side left

pack [frame .f2 -bd 5]
button .f2.inst -text Install -command install
button .f2.cancel -text Cancel -command exit
pack .f2.inst .f2.cancel -side left -padx 5

pack [frame .f3 -bd 5] -fill x
label .f3.result -text {ok} -relief groove -anchor w
pack .f3.result -fill x

.f1.path.path insert end [file dirname [file dirname [info nameofexecutable]]]
focus .f1.path.path
