# $Id: cwind.tcl 1.5 2003/09/05 14:06:14 s-imai s-imai $
#
# Copyright (C) 2000-2001 Satoshi Imai
#

package provide cwind 1.4.0

load [file join [file dirname [info script]] cwind.dll]
 
namespace eval ::cwind {} {

namespace export waitwind minimizeAll

proc ::cwind::waitwind {title {max 5} } {
	set cur [::cwind::gettext]
	set i 1
	set delay 100
	set max [expr $max*1000/$delay]
	while { [string match $title $cur]!=1 && $i<=$max} {
		set cur [::cwind::gettext]
		incr i
		after $delay
		update
	}
	if {$i>$max} {puts "Can't find the window : $title"; return 0} else { return $i}
}

proc ::cwind::minimizeAll {} { 
	set ll [::cwind::wlist ]
	foreach elem $ll {
		if {[::cwind::state -exact $elem]!="Minimized"} {
			::cwind::show -exact $elem
			after 100
			::cwind::minimize
		}
	}
}

}
