#! /bin/tcsh -f
#
#
#

set hkl = "-hkl sqrt_ds.hkl "
foreach num ( `seq -f%03.0f 1 360` )

set phi = `echo $num | awk '{print $1-1}'`

./fastBragg $hkl -N 1 -mat Adiff.mat -nonoise \
    -detpixels 3072 -pixel 0.1024 -distance 300 \
    -phi $phi -osc 0.001 \
    -floatimage still_diffuse_${num}.bin \
    -intimage still_diffuse_${num}.img &
set hkl

sleep 0.5
set test = `echo $num | awk '{print ($1%20==0)}'`
if( $test ) wait

end
wait


set hkl = "-hkl P1.hkl "
foreach num ( `seq -f%03.0f 1 360` )

set phi = `echo $num | awk '{print $1-1}'`

./fastBragg $hkl -N 10 -mat Aspot.mat -binary_spots -nonoise \
    -detpixels 3072 -pixel 0.1024 -distance 300 -oversample 2 \
    -phi $phi -osc 0.001 \
    -floatimage still_spots_${num}.bin \
    -intimage still_spots_${num}.img &
set hkl

sleep 0.5
set test = `echo $num | awk '{print ($1%20==0)}'`
if( $test ) wait

end
wait



set hkl = "-hkl P1.hkl "
foreach num ( `seq -f%03.0f 1 360` )

set phi = `echo $num | awk '{print $1-1}'`

./fastBragg $hkl -N 10 -mat Aspot.mat -binary_spots -nonoise \
    -detpixels 3072 -pixel 0.1024 -distance 300 -oversample 2 \
    -phi $phi -osc 1 -phisteps 100 \
    -floatimage osc_spots_${num}.bin \
    -intimage osc_spots_${num}.img &
set hkl

sleep 0.5
set test = `echo $num | awk '{print ($1%20==0)}'`
if( $test ) wait

end
wait

