



set CELL = ( 78.805   78.805   38.218  90.00  90.00  90.00 )

set newcell = `echo $CELL 4 | awk '{print $NF*$1,$NF*$2,$NF*$3,90,90,90}'`


grep "ATOM" ../Lys04_refine_3.pdb >! atoms.pdb


pdbset xyzin atoms.pdb xyzout sfallme.pdb << EOF
cell $newcell
SPACE 1
EOF

rm -f fmodel.mtz
phenix.fmodel high_resolution=1.6 sfallme.pdb output.file_name=fmodel.mtz




pdbset xyzin ../ADC_10_aligned_ready.pdb xyzout aligned_all.pdb << EOF
ROTATE INVERT POLAR 83.90015 -122.86564 34.34653
SHIFT -7.24122 5.92523 9.28398
EOF



awk '{print} /OXT/{print "TER"}'  aligned_all.pdb |\
awk 'BEGIN{conf="001";file="asu_" conf ".pdb";} \
  {print >> file}\
 /^TER/{close(file);conf=sprintf("%03d",++conf);file="asu_" conf ".pdb"}\
END{close(file)}'
rm -f asu_031.pdb


set CELL = ( 78.805 78.805 38.218 90 90 90 )
set SG   = P43212

pdbset xyzin aligned_all.pdb xyzout sfallme.pdb << EOF
CELL $CELL
SPACE $SG
EOF
rm -f aligned_all.mtz
phenix.fmodel high_resolution=1.6 sfallme.pdb \
   output.file_name=aligned_all.mtz k_sol=0.38 b_sol=40
cad hklin1 aligned_all.mtz hklout average.mtz << EOF
labin file 1 all
scale file 1 0.03333333333
EOF
~/projects/fastBragg/mtz_to_P1hkl.com average.mtz 
echo "0 0 0 6000" >> P1.hkl





foreach conf ( `seq -f%03.0f 1 30` )

foreach op ( `seq 1 8` )

set oper = `awk -v SG=$SG -v op=$op '$4==SG{for(i=op;i>0;--i){getline}; print}' ${CLIBD}/symop.lib`

pdbset xyzin asu_${conf}.pdb xyzout symgen_${conf}_${op}.pdb << EOF
CELL $CELL
symgen $oper
EOF

pdbset xyzin symgen_${conf}_${op}.pdb xyzout sfallme.pdb << EOF
cell $newcell
SPACE 1
EOF

rm -f symgen_${conf}_${op}.mtz
phenix.fmodel high_resolution=1.6 sfallme.pdb \
   output.file_name=symgen_${conf}_${op}.mtz

end
end


# convert to text because sftools sucks
foreach op ( `seq 1 8` )
 foreach conf ( `seq -f%03.0f 1 30` )

  if(-e symgen_${conf}_${op}.txt) continue
  echo "$conf $op"
  echo "nref -1\nFORMAT '(3i6,2g35.20)'" |\
    mtzdump hklin symgen_${conf}_${op}.mtz |\
  awk 'BEGIN{RTD=45/atan2(1,1)}\
    substr($0,1,18)==sprintf("%6d%6d%6d",$1,$2,$3){\
      print $1,$2,$3,$4*sin($5/RTD),$4*cos($5/RTD)}' |\
  cat >! symgen_${conf}_${op}.txt

 end
end


foreach op ( `seq 1 8` )

cat symgen_???_${op}.txt |\
awk 'BEGIN{RTD=45/atan2(1,1)}\
     {hkl=$1" "$2" "$3;++n[hkl];sinsum[hkl]+=$4;cossum[hkl]+=$5;\
      Isum[hkl]+=$4*$4+$5*$5} END{\
     for(hkl in Isum){Iavg=Isum[hkl]/n[hkl];\
       sinavg=sinsum[hkl]/n[hkl];cosavg=cossum[hkl]/n[hkl];\
       sqrFavg=sinavg**2+cosavg**2;\
       print hkl,Iavg-sqrFavg }}' |\
cat >! ds_${op}.hkl

end

cat ds_?.hkl |\
awk '{h=-$1;k=-$2;l=-$3;hkl=$1" "$2" "$3;\
      friedel[hkl]=h" "k" "l;\
      ++n[hkl];Isum[hkl]+=$4;} END{\
     for(hkl in Isum){\
       print hkl,sqrt(Isum[hkl]);\
       print friedel[hkl],sqrt(Isum[hkl]);\
       }}' |\
cat >! sqrt_ds.hkl


UBtoA.awk << EOF >! Adiff.mat
CELL $newcell
MISSET 10 30 50
EOF

UBtoA.awk << EOF >! Aspot.mat
CELL $CELL
MISSET 10 30 50
EOF



set hkl = "-hkl sqrt_ds.hkl "
foreach num ( `seq -f%03.0f 1 360` )

set phi = `echo $num | awk '{print $1-1}'`

./fastBragg $hkl -N 1 -mat Adiff.mat -nonoise \
    -detpixels 3072 -pixel 0.1024 -distance 300 \
    -phi $phi -osc 0.001 \
    -floatimage still_diffuse_${num}.bin \
    -intimage still_diffuse_${num}.img &
set hkl

set test = `echo $num | awk '{print $1%20}'`
if( $test ) wait

end
wait


set hkl = "-hkl P1.hkl "
foreach num ( `seq -f%03.0f 1 360` )

set phi = `echo $num | awk '{print $1-1}'`

./fastBragg $hkl -N 10 -mat Aspot.mat -binary_spots -nonoise \
    -detpixels 3072 -pixel 0.1024 -distance 300 -oversample 2 \
    -phi $phi -osc 0.001 \
    -floatimage still_spots_${num}.bin \
    -intimage still_spots_${num}.img &
set hkl

set test = `echo $num | awk '{print $1%20}'`
if( $test ) wait

end
wait



set hkl = "-hkl P1.hkl "
foreach num ( `seq -f%03.0f 1 360` )

set phi = `echo $num | awk '{print $1-1}'`

./fastBragg $hkl -N 10 -mat Aspot.mat -binary_spots -nonoise \
    -detpixels 3072 -pixel 0.1024 -distance 300 -oversample 2 \
    -phi $phi -osc 1 -phisteps 100 \
    -floatimage osc_spots_${num}.bin \
    -intimage osc_spots_${num}.img &

sleep 0.5
set hkl

set test = `echo $num | awk '{print $1%20}'`
if( $test ) wait

end
wait



mkdir proc
cd proc
xds_runme.com P43212 ../osc_spots_\?\?\?.img 
diff.com ../average.mtz truncated.mtz -weigh
foreach F ( ref test )
cad hklin1 scaleited.mtz hklout wilsonme.mtz << EOF > /dev/null
labin file 1 E1=F${F} E2=SIGF${F}
EOF
echo "nref -1\nlreso\nFORMAT '(3i6,3g35.20)'" |\
 mtzdump hklin wilsonme.mtz |\
awk 'substr($0,1,18)==sprintf("%6d%6d%6d",$1,$2,$3) && $5+0 !~ -999{print $4/4,$5,$6}' |\
awk -v bs=0.002 '{bin=sprintf("%.0f",$1/bs);sum1[bin]+=$2*$2;sum2[bin]+=$3;++count[bin]}\
     END{for(bin in sum1) print bin*bs,sum1[bin]/count[bin],sum2[bin]/count[bin],count[bin]}' |\
sort -g |\
tee wilson_${F}.txt | wc
end


set dir = /data3/anonymous/pub/Illuin/lyso_DS
foreach num ( `seq -f%03.0f 1 360` )

set phi = `echo $num | awk '{print $1-1}'`

float_add -scale1 0.001 osc_spots_${num}.bin still_diffuse_${num}.bin

./noisify -seed $num -scale 1000 \
    -detpixels 3072 -pixel 0.1024 -distance 300 \
    -phi $phi -osc 1 \
    -floatfile output.bin \
    -noisefile ${dir}/diffuse_lyso_${num}.img 

end


foreach num ( `seq -f%03.0f 1 360` )

    echo "$num"
    convert -depth 16 -type Grayscale -colorspace GRAY \
     -size 3072x3072+512 GRAY:${dir}/diffuse_lyso_${num}.img \
     -filter Box -geometry 512x512 \
     -fx 'intensity*5*256' -depth 8 -normalize -negate \
     -crop 512x300+0+0 +repage frame${num}.png 

end
convery frame???.png frames.gif

ffmpeg -r 5 -i frame%03d.png -y frames.wmv

