#! /bin/tcsh -f
#
#	convert the first F in an MTZ file into a symmetry-expanded text list
#
#		James Holton 5-5-13
#
#
set mtzfile = "$1"
if(! -e "$mtzfile") then
    if("$mtzfile" != "") echo "$mtzfile does not exist"
    cat << EOF
usage: $0 mtzfile.mtz
EOF
    exit 9
endif

set tempfile = ${CCP4_SCR}/tmp_dump$$

set firstF = `mtzdmp $mtzfile | grep -v "H H H " | grep "$2" | awk 'NF>5 && $(NF-1)=="F"{print $NF;exit}'`
if("$firstF" == "") then
    echo "ERROR: cannot find any Fs in $mtzfile"
    exit 9
endif
echo "selected $firstF"

cad hklin1 $mtzfile hklout ${tempfile}P1.mtz << EOF > /dev/null
labin file 1 E1=$firstF
outlim space 1
EOF

echo "nref -1\nFORMAT '(3i6,3g35.20)'" |\
mtzdump hklin ${tempfile}P1.mtz |\
awk 'substr($0,1,18)==sprintf("%6d%6d%6d",$1,$2,$3) && $4!="?"{\
      print $1,$2,$3,$4; print -$1,-$2,-$3,$4}' |\
awk '{printf("%4d %4d %4d %s\n",$1,$2,$3,$4)}' |\
cat >! P1.hkl

rm -f ${tempfile}P1.mtz

set count = `cat P1.hkl | wc -l`
echo "$count h k l F lines output to P1.hkl"
